<?php

/*-----------------------------------------------------------------------------------*/
// Button
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['button'] = array(
	'no_preview' => true,
	'params' => array(
		'url' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Button URL', 'textdomain'),
			'desc' => __('Add the button\'s url eg http://example.com', 'textdomain')
		),
		'style' => array(
			'type' => 'select',
			'label' => __('Button Color', 'textdomain'),
			'desc' => __('Select the button\'s style, ie the button\'s colour', 'textdomain'),
			'options' => array(
				'1' => 'Main Color 1',
				'2' => 'Main Color 2',
				'3' => 'Main Color 3',
				'4' => 'Main Color 4',
				'5' => 'Main Color 5'
			)
		),
		'type' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase'
			)
		),
		'target' => array(
			'type' => 'select',
			'label' => __('Button Target', 'textdomain'),
			'desc' => __('_self = open in same window. _blank = open in new window', 'textdomain'),
			'options' => array(
				'_self' => '_self',
				'_blank' => '_blank'
			)
		),
		'content' => array(
			'std' => 'Button Text',
			'type' => 'text',
			'label' => __('Button\'s Text', 'textdomain'),
			'desc' => __('Add the button\'s text', 'textdomain'),
		)
	),
	'shortcode' => '[button url="{{url}}" main_color_number="{{style}}" type="{{type}}" target="{{target}}"] {{content}} [/button]',
	
	'popup_title' => __('Insert Button Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
// Quotes
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['blockquote'] = array(
	'no_preview' => true,
	'params' => array(
		'author' => array(
			'std' => 'Name',
			'type' => 'text',
			'label' => __('Author', 'textdomain'),
			'desc' => __('The Author of the used quote', 'textdomain')
		),
		'align' => array(
			'type' => 'select',
			'label' => __('Quote Align', 'textdomain'),
			'desc' => __('Align the quote left or right to the other content', 'textdomain'),
			'options' => array(
				'left' => 'left ',
				'right' => 'right'
			)
		),
		'content' => array(
			'std' => 'Quote',
			'type' => 'text',
			'label' => __('Quote', 'textdomain'),
			'desc' => __('The quote\'s text', 'textdomain'),
		)
	),
	'shortcode' => '[blockquote author="{{author}}" align="{{align}}"] {{content}} [/blockquote]',
	
	'popup_title' => __('Insert Blockquote Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Spacer Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['spacer'] = array(
	'no_preview' => true,
	'params' => array(
		'height' => array(
			'std' => '20px',
			'type' => 'text',
			'label' => __('Height of the Spacer', 'textdomain'),
			'desc' => __('Creates a space area of this height', 'textdomain')
		)
	),
	'shortcode' => '[spacer height="{{height}}"]',
	
	'popup_title' => __('Insert Spacer Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Slider Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['slider'] = array(
	'no_preview' => true,
	'params' => array(
		'name' => array(
			'std' => 'Home Slider',
			'type' => 'text',
			'label' => __('Current Slider Slug', 'textdomain'),
			'desc' => __('Please enter here the field content out of the Slider Editor', 'textdomain')
		)
	),
	'shortcode' => '[alterego_slider_home name="{{name}}"]',
	
	'popup_title' => __('Insert Slider Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Divider Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['divider'] = array(
	'no_preview' => true,
	'params' => array(
		'before' => array(
			'std' => '25px',
			'type' => 'text',
			'label' => __('Space before Divider', 'textdomain'),
			'desc' => __('Creates a space area before the divider line', 'textdomain')
		),
		'after' => array(
			'std' => '40px',
			'type' => 'text',
			'label' => __('Space after Divider', 'textdomain'),
			'desc' => __('Creates a space area afterthe divider line', 'textdomain')
		)
	),
	'shortcode' => '[divider before="{{before}}" after="{{after}}"]',
	
	'popup_title' => __('Insert Spacer Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Twitter Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['twitter'] = array(
	'no_preview' => true,
	'params' => array(
		'user' => array(
			'std' => 'envato',
			'type' => 'text',
			'label' => __('User', 'textdomain'),
			'desc' => __('Twitter User name', 'textdomain')
		),
		'count' => array(
			'std' => '8',
			'type' => 'text',
			'label' => __('Count', 'textdomain'),
			'desc' => __('How many Tweets?', 'textdomain')
		)
	),
	'shortcode' => '[twitter user="{{user}}" count="{{count}}"]',
	
	'popup_title' => __('Insert Twitter Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Skills Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['skill'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => 'title',
			'type' => 'text',
			'label' => __('Title', 'textdomain'),
			'desc' => __('Written Words on the bar', 'textdomain')
		),
		'percentage' => array(
			'std' => '50',
			'type' => 'text',
			'label' => __('Percentage', 'textdomain'),
			'desc' => __('Level of filling (in %)', 'textdomain')
		),
		'color' => array(
			'type' => 'select',
			'label' => __('Bar Color', 'textdomain'),
			'desc' => __('Select the button\'s style, ie the colour', 'textdomain'),
			'options' => array(
				'1' => 'Main Color 1',
				'2' => 'Main Color 2',
				'3' => 'Main Color 3',
				'4' => 'Main Color 4',
				'5' => 'Main Color 5'
			)
		)
	),
	'shortcode' => '[skill title="{{title}}" percentage="{{percentage}} main_color_number="{{color}}"]',
	
	'popup_title' => __('Insert Spacer Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Lightbox
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['lightbox'] = array(
	'no_preview' => true,
	'params' => array(
		'thumb' => array(
			'std' => 'http://1.s3.envato.com/files/5926636/web2.jpg',
			'type' => 'text',
			'label' => __('Thumb Picture', 'textdomain'),
			'desc' => __('Thumbnail picture to appear in the content', 'textdomain')
		),
		'align' => array(
			'type' => 'select',
			'label' => __('Align', 'textdomain'),
			'desc' => __('Thumbnail align', 'textdomain'),
			'options' => array(
				'left' => 'Left',
				'right' => 'Right'
				)
		),
		'hover' => array(
			'std' => 'Click me',
			'type' => 'text',
			'label' => __('Hover Text', 'textdomain'),
			'desc' => __('Text on hover', 'textdomain')
		),
		'link' => array(
			'std' => 'http://www.youtube.com/watch?v=Nf48xx6UQwU&width=720&height=435&hd=1',
			'type' => 'text',
			'label' => __('Lightbox URL', 'textdomain'),
			'desc' => __('URL to image or (embedded) youtube/vimeo to appear in Lightbox', 'textdomain')
		),
		'title' => array(
			'std' => 'The Title',
			'type' => 'text',
			'label' => __('Title in Lightbox', 'textdomain'),
			'desc' => __('Title shown at the bottom of the Lightbox', 'textdomain')
		)	
	),
	'shortcode' => '[lightbox thumb="{{thumb}}" link="{{link}}" title="{{title}}" hover="{{hover}}"]',
	
	'popup_title' => __('Insert Lightbox Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Video
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['video'] = array(
	'no_preview' => true,
	'params' => array(
		'source' => array(
			'type' => 'select',
			'label' => __('Source', 'textdomain'),
			'desc' => __('Youtube or Vimeo video?', 'textdomain'),
			'options' => array(
				'youtube' => 'youtube',
				'vimeo' => 'vimeo'
				)
		),
		'videoid' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Video ID', 'textdomain'),
			'desc' => __('ID of the Video to embed', 'textdomain')
		),
		'width' => array(
			'std' => '500',
			'type' => 'text',
			'label' => __('Width', 'textdomain'),
			'desc' => __('Width of the Video', 'textdomain')
		),
		'height' => array(
			'std' => '281',
			'type' => 'text',
			'label' => __('Height', 'textdomain'),
			'desc' => __('Height of the Video', 'textdomain')
		)	
	),
	'shortcode' => '[video source="{{source}}" video_id="{{videoid}}" width="{{width}}" height="{{height}}"]',
	
	'popup_title' => __('Insert Video Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Pricetables
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['pricetable3'] = array(
	'no_preview' => true,
	'params' => array(
		'column1'  => array(
			'type' => 'headline',
			'std' => __('Column 1', 'textdomain')
		),
		'highlight1' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title1' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price1' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline1' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content1' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type1' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text1' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url1' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column2'  => array(
			'type' => 'headline',
			'std' => __('Column 2', 'textdomain')
		),
		'highlight2' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title2' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price2' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline2' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content2' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type2' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text2' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url2' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column3'  => array(
			'type' => 'headline',
			'std' => __('Column 3', 'textdomain')
		),
		'highlight3' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title3' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price3' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline3' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content3' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type3' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text3' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url3' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		)

	),
	'shortcode' => '[pricetable columns="3"][pricetable_column highlight="{{highlight1}}" title="{{title1}}" price="{{price1}}" price_subline="{{price_subline1}}" button_type="{{button_type1}}" button_text="{{button_text1}}"] {{content1}} [/pricetable_column][pricetable_column highlight="{{highlight2}}" title="{{title2}}" price="{{price2}}" price_subline="{{price_subline2}}" button_type="{{button_type2}}" button_text="{{button_text2}}"] {{content2}} [/pricetable_column][pricetable_column highlight="{{highlight3}}" title="{{title3}}" price="{{price3}}" price_subline="{{price_subline3}}" button_type="{{button_type3}}" button_text="{{button_text3}}"] {{content3}} [/pricetable_column][/pricetable]',
	
	'popup_title' => __('Insert Pricetable 3 Columns Shortcode', 'textdomain')
);

$zilla_shortcodes['pricetable4'] = array(
	'no_preview' => true,
	'params' => array(
		'column1'  => array(
			'type' => 'headline',
			'std' => __('Column 1', 'textdomain')
		),
		'highlight1' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title1' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price1' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline1' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content1' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type1' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text1' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url1' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column2'  => array(
			'type' => 'headline',
			'std' => __('Column 2', 'textdomain')
		),
		'highlight2' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title2' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price2' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline2' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content2' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type2' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text2' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url2' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column3'  => array(
			'type' => 'headline',
			'std' => __('Column 3', 'textdomain')
		),
		'highlight3' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title3' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price3' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline3' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content3' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type3' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text3' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url3' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column4'  => array(
			'type' => 'headline',
			'std' => __('Column 4', 'textdomain')
		),
		'highlight4' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title4' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price4' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline4' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content4' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type4' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text4' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url4' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		)

	),
	'shortcode' => '[pricetable columns="4"][pricetable_column highlight="{{highlight1}}" title="{{title1}}" price="{{price1}}" price_subline="{{price_subline1}}" button_type="{{button_type1}}" button_text="{{button_text1}}"] {{content1}} [/pricetable_column][pricetable_column highlight="{{highlight2}}" title="{{title2}}" price="{{price2}}" price_subline="{{price_subline2}}" button_type="{{button_type2}}" button_text="{{button_text2}}"] {{content2}} [/pricetable_column][pricetable_column highlight="{{highlight3}}" title="{{title3}}" price="{{price3}}" price_subline="{{price_subline3}}" button_type="{{button_type3}}" button_text="{{button_text3}}"] {{content3}} [/pricetable_column][pricetable_column highlight="{{highlight4}}" title="{{title4}}" price="{{price4}}" price_subline="{{price_subline4}}" button_type="{{button_type4}}" button_text="{{button_text4}}"] {{content4}} [/pricetable_column][/pricetable]',
	
	'popup_title' => __('Insert Pricetable 4 Columns Shortcode', 'textdomain')
);


$zilla_shortcodes['pricetable4'] = array(
	'no_preview' => true,
	'params' => array(
		'column1'  => array(
			'type' => 'headline',
			'std' => __('Column 1', 'textdomain')
		),
		'highlight1' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title1' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price1' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline1' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content1' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type1' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text1' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url1' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column2'  => array(
			'type' => 'headline',
			'std' => __('Column 2', 'textdomain')
		),
		'highlight2' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title2' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price2' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline2' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content2' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type2' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text2' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url2' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column3'  => array(
			'type' => 'headline',
			'std' => __('Column 3', 'textdomain')
		),
		'highlight3' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title3' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price3' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline3' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content3' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type3' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text3' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url3' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column4'  => array(
			'type' => 'headline',
			'std' => __('Column 4', 'textdomain')
		),
		'highlight4' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title4' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price4' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline4' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content4' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type4' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text4' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url4' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		),
		'column5'  => array(
			'type' => 'headline',
			'std' => __('Column 5', 'textdomain')
		),
		'highlight5' => array(
			'type' => 'select',
			'label' => __('Highlighted?', 'textdomain'),
			'desc' => __('Highlighted or Normal column', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'highlight' => 'Highlight'
			)
		),
		'title5' => array(
			'type' => 'text',
			'label' => __('Column Title', 'textdomain'),
			'desc' => __('Add the Headline that will go above the column content', 'textdomain'),
			'std' => 'Title'
		),
		'price5' => array(
			'type' => 'text',
			'label' => __('Price', 'textdomain'),
			'desc' => __('Add the Price that will go above the Teaser content', 'textdomain'),
			'std' => '$99'
		),
		'price_subline5' => array(
			'std' => '1 month',
			'type' => 'text',
			'label' => __('Price Subline', 'textdomain'),
			'desc' => __('Add a subline to the text', 'textdomain')
		),
		'content5' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Column Content', 'textdomain'),
			'desc' => __('Describing content. Will accept HTML', 'textdomain')
		),
		'button_type5' => array(
			'type' => 'select',
			'label' => __('Button Type', 'textdomain'),
			'desc' => __('Select the button\'s type', 'textdomain'),
			'options' => array(
				'normal' => 'Normal',
				'purchase' => 'Purchase',
				'none' => 'None'
			)
		),
		'button_text5' => array(
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the button', 'textdomain'),
			'std' => 'Order now'
		),
		'button_url5' => array(
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('Link on the button', 'textdomain'),
			'std' => '#'
		)

	),
	'shortcode' => '[pricetable columns="5"][pricetable_column highlight="{{highlight1}}" title="{{title1}}" price="{{price1}}" price_subline="{{price_subline1}}" button_type="{{button_type1}}" button_text="{{button_text1}}"] {{content1}} [/pricetable_column][pricetable_column highlight="{{highlight2}}" title="{{title2}}" price="{{price2}}" price_subline="{{price_subline2}}" button_type="{{button_type2}}" button_text="{{button_text2}}"] {{content2}} [/pricetable_column][pricetable_column highlight="{{highlight3}}" title="{{title3}}" price="{{price3}}" price_subline="{{price_subline3}}" button_type="{{button_type3}}" button_text="{{button_text3}}"] {{content3}} [/pricetable_column][pricetable_column highlight="{{highlight4}}" title="{{title4}}" price="{{price4}}" price_subline="{{price_subline4}}" button_type="{{button_type4}}" button_text="{{button_text4}}"] {{content4}} [/pricetable_column][pricetable_column highlight="{{highlight5}}" title="{{title5}}" price="{{price5}}" price_subline="{{price_subline5}}" button_type="{{button_type5}}" button_text="{{button_text5}}"] {{content5}} [/pricetable_column][/pricetable]',
	
	'popup_title' => __('Insert Pricetable 5 Columns Shortcode', 'textdomain')
);
/*-----------------------------------------------------------------------------------*/
/*	Team 3 Config
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['team3'] = array(
    	'no_preview' => true,
	'params' => array(
		'member1'  => array(
			'type' => 'headline',
			'std' => __('Member 1', 'textdomain')
		),
		'name1' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position1' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image1' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content1' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		),
		'member2'  => array(
			'type' => 'headline',
			'std' => __('Member 2', 'textdomain')
		),
		'name2' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position2' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image2' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content2' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		),
		'member3'  => array(
			'type' => 'headline',
			'std' => __('Member 3', 'textdomain')
		),
		'name3' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position3' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image3' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content3' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		),
	),
	'shortcode' => '[team columns=3] [team_member name="{{name1}}" position="{{position1}}" image="{{image1}}" linked="{{linked1}}" facebook="{{facebook1}}" twitter="{{twitter1}}" skype="{{skype1}}" mail="{{mail1}}"]{{content1}}[/team_member][team_member name="{{name2}}" position="{{position2}}" image="{{image2}}" linked="{{linked2}}" facebook="{{facebook2}}" twitter="{{twitter2}}" skype="{{skype2}}" mail="{{mail2}}"]{{content1}}[/team_member][team_member name="{{name3}}" position="{{position3}}" image="{{image3}}" linked="{{linked3}}" facebook="{{facebook3}}" twitter="{{twitter3}}" skype="{{skype3}}" mail="{{mail3}}"]{{content3}}[/team_member] [/team]',
	
	'popup_title' => __('Insert Team 3 Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Team 4 Config
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['team4'] = array(
    	'no_preview' => true,
	'params' => array(
		'member1'  => array(
			'type' => 'headline',
			'std' => __('Member 1', 'textdomain')
		),
		'name1' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position1' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image1' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail1' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content1' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		),
		'member2'  => array(
			'type' => 'headline',
			'std' => __('Member 2', 'textdomain')
		),
		'name2' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position2' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image2' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content2' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		),
		'member3'  => array(
			'type' => 'headline',
			'std' => __('Member 3', 'textdomain')
		),
		'name3' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position3' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image3' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail3' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content3' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		),
		'member4'  => array(
			'type' => 'headline',
			'std' => __('Member 4', 'textdomain')
		),
		'name4' => array(
			'std' => 'John Doe',
			'type' => 'text',
			'label' => __('Name', 'textdomain'),
			'desc' => __('The Name of the Team Member', 'textdomain'),
		),
		'position4' => array(
			'std' => 'Developer',
			'type' => 'text',
			'label' => __('Position', 'textdomain'),
			'desc' => __('A closer description', 'textdomain'),
		),
		'image4' => array(
			'std' => '../wp-content/themes/alterego/images/other/team_1.png',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of 225px wide picture', 'textdomain'),
		),
		'linked4' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('LinkedIn Profile', 'textdomain'),
			'desc' => __('URL of the LinkedIn Profile(blank for no icon)', 'textdomain'),
		),
		'facebook4' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Facebook Profile', 'textdomain'),
			'desc' => __('URL of the Facebook Profile(blank for no icon)', 'textdomain'),
		),
		'twitter4' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Twitter Profile', 'textdomain'),
			'desc' => __('URL of the Twitter Profile(blank for no icon)', 'textdomain'),
		),
		'skype4' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Skype Nr./ID', 'textdomain'),
			'desc' => __('ID or Nr. to call(blank for no icon)', 'textdomain'),
		),
		'mail4' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Mail Address', 'textdomain'),
			'desc' => __('Mail Address to write to(blank for no icon)', 'textdomain'),
		),
		'content4' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content', 'textdomain'),
			'desc' => __('Some describing words, will accept HTML', 'textdomain'),
		)
	),
	'shortcode' => '[team] [team_member name="{{name1}}" position="{{position1}}" image="{{image1}}" linked="{{linked1}}" facebook="{{facebook1}}" twitter="{{twitter1}}" skype="{{skype1}}" mail="{{mail1}}"]{{content1}}[/team_member][team_member name="{{name2}}" position="{{position2}}" image="{{image2}}" linked="{{linked2}}" facebook="{{facebook2}}" twitter="{{twitter2}}" skype="{{skype2}}" mail="{{mail2}}"]{{content1}}[/team_member][team_member name="{{name3}}" position="{{position3}}" image="{{image3}}" linked="{{linked3}}" facebook="{{facebook3}}" twitter="{{twitter3}}" skype="{{skype3}}" mail="{{mail3}}"]{{content3}}[/team_member][team_member name="{{name4}}" position="{{position4}}" image="{{image4}}" linked="{{linked4}}" facebook="{{facebook4}}" twitter="{{twitter4}}" skype="{{skype4}}" mail="{{mail4}}"]{{content4}}[/team_member] [/team]',
	
	'popup_title' => __('Insert Team 4 Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Toggle Config
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['toggle'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[toggles] {{child_shortcode}}  [/toggles]',
    'popup_title' => __('Insert Toggles Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
		'title' => array(
			'type' => 'text',
			'label' => __('Toggle Title', 'textdomain'),
			'desc' => __('Add the Headline on the toggle head', 'textdomain'),
			'std' => 'Title'
		),
		'content' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Toggle Content', 'textdomain'),
			'desc' => __('Toggle content. Will accept HTML', 'textdomain')
		)
		),
        'shortcode' => '[toggle title="{{title}}"]{{content}}[/toggle]',
        'clone_button' => __('Add Toggle', 'textdomain')
    )
);

/*-----------------------------------------------------------------------------------*/
/*	Testamonial Config
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['rotator'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[rotator] {{child_shortcode}}  [/rotator]',
    'popup_title' => __('Insert Testamonial Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
		'title' => array(
			'type' => 'text',
			'label' => __('Testamonial Title', 'textdomain'),
			'desc' => __('Add the Headline on the testamonial head', 'textdomain'),
			'std' => 'Title'
		),
		'subline' => array(
			'type' => 'subline',
			'label' => __('Testamonial Subline', 'textdomain'),
			'desc' => __('Add another line on the testamonial head. HTML accepted', 'textdomain'),
			'std' => '<a href="#">Subline</a>'
		),
		'content' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Testamonial Content', 'textdomain'),
			'desc' => __('Testamonial content. Will accept HTML', 'textdomain')
		)
		),
        'shortcode' => '[rotator_item title="{{title}}" subline="{{subline}}"]{{content}}[/rotator_item]',
        'clone_button' => __('Add Testamonial', 'textdomain')
    )
);

/*-----------------------------------------------------------------------------------*/
/*	FAQ Config
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['faq'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[faq] {{child_shortcode}}  [/faq]',
    'popup_title' => __('Insert FAQ Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
		'title' => array(
			'type' => 'text',
			'label' => __('Toggle Title', 'textdomain'),
			'desc' => __('Add the Headline on the toggle head', 'textdomain'),
			'std' => 'Title'
		),
		'content' => array(
			'std' => 'Content',
			'type' => 'textarea',
			'label' => __('Toggle Content', 'textdomain'),
			'desc' => __('Toggle content. Will accept HTML', 'textdomain')
		)
		),
        'shortcode' => '[faq_item title="{{title}}"]{{content}}[/faq_item]',
        'clone_button' => __('Add FAQ item', 'textdomain')
    )
);

/*-----------------------------------------------------------------------------------*/
/*	Tabs
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['tabs'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[tabs] {{child_shortcode}}  [/tabs]',
    'popup_title' => __('Insert Tab Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
            'title' => array(
                'std' => 'Title',
                'type' => 'text',
                'label' => __('Tab Title', 'textdomain'),
                'desc' => __('Title of the tab', 'textdomain'),
            ),
            'content' => array(
                'std' => 'Tab Content',
                'type' => 'textarea',
                'label' => __('Tab Content', 'textdomain'),
                'desc' => __('Add the tabs content', 'textdomain')
            )
        ),
        'shortcode' => '[tab title="{{title}}"] {{content}} [/tab]',
        'clone_button' => __('Add Tab', 'textdomain')
    )
);

/*-----------------------------------------------------------------------------------*/
/* Infobox Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['infobox'] = array(
	'no_preview' => true,
	'params' => array(
		'style' => array(
			'type' => 'select',
			'label' => __('Color', 'textdomain'),
			'desc' => __('Select the box\'s style, ie the box\'s colour', 'textdomain'),
			'options' => array(
				'1' => 'Main Color 1',
				'2' => 'Main Color 2',
				'3' => 'Main Color 3',
				'4' => 'Main Color 4',
				'5' => 'Main Color 5'
			)
		),
		'content' => array(
			'std' => 'Text',
			'type' => 'text',
			'label' => __('Box\'s Text', 'textdomain'),
			'desc' => __('Add the box\'s text', 'textdomain'),
		)
	),
	'shortcode' => '[infobox main_color_number="{{style}}"] {{content}} [/infobox]',
	
	'popup_title' => __('Insert Infobox Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/* Card Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['card'] = array(
	'no_preview' => true,
	'params' => array(
		'icon' => array(
			'std' => '../images/other/is_1.png',
			'type' => 'text',
			'label' => __('Icon', 'textdomain'),
			'desc' => __('Add the card\'s icon (50x50px)', 'textdomain'),
		),
		'title' => array(
			'std' => 'Title',
			'type' => 'text',
			'label' => __('Title', 'textdomain'),
			'desc' => __('Headline of the card', 'textdomain'),
		),
		'image' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Image', 'textdomain'),
			'desc' => __('URL of the Image', 'textdomain'),
		),
		'button_text' => array(
			'std' => 'Read More',
			'type' => 'text',
			'label' => __('Button Text', 'textdomain'),
			'desc' => __('Text on the Button (no text = no button)', 'textdomain'),
		),
		'button_link' => array(
			'std' => '#',
			'type' => 'text',
			'label' => __('Button Link', 'textdomain'),
			'desc' => __('URL the Button links to', 'textdomain'),
		),
		'button_target' => array(
			'type' => 'select',
			'label' => __('Button Target', 'textdomain'),
			'desc' => __('Open in new window/tab or self', 'textdomain'),
			'options' => array(
				'_self' => '_self',
				'_blank' => '_blank'
			)
		),
		'content' => array(
			'std' => 'Text',
			'type' => 'textarea',
			'label' => __('Card\'s Text', 'textdomain'),
			'desc' => __('Add the card\'s text', 'textdomain'),
		)
	),
	'shortcode' => '[card icon="{{icon}}" image="{{image}}" title="{{title}}" button_text="{{button_text}}" button_link="{{button_link}}" button_target="{{button_target}}"] {{content}} [/card]',
	
	'popup_title' => __('Insert Card Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Columns Config
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['columns'] = array(
	'params' => array(),
	'shortcode' => ' {{child_shortcode}} ', // as there is no wrapper shortcode
	'popup_title' => __('Insert Columns Shortcode', 'textdomain'),
	'no_preview' => true,
	
	// child shortcode is clonable & sortable
	'child_shortcode' => array(
		'params' => array(
			'column' => array(
				'type' => 'select',
				'label' => __('Column Type', 'textdomain'),
				'desc' => __('Select the type, ie width of the column.', 'textdomain'),
				'options' => array(
					'one_half' => 'One Half',
					'one_half_last' => 'One Half Last',
					'one_third' => 'One Third',
					'one_third_last' => 'One Third Last',
					'two_third' => 'Two Thirds',
					'two_third_last' => 'Two Thirds Last',
					'one_fourth' => 'One Fourth',
					'one_fourth_last' => 'One Fourth Last',
					'one_fifth' => 'One Fifth',
					'one_fifth_last' => 'One Fifth Last',
					'one_sixth' => 'One Sixth',
					'one_sixth_last' => 'One Sixth Last',
				)
			),
			'content' => array(
				'std' => '',
				'type' => 'textarea',
				'label' => __('Column Content', 'textdomain'),
				'desc' => __('Add the column content.', 'textdomain'),
			)
		),
		'shortcode' => '[{{column}}] {{content}} [/{{column}}] ',
		'clone_button' => __('Add Column', 'textdomain')
	)
);

?>